Uses(mvtnorm)
Uses(MCMCpack)
Uses(lattice)
Uses(Matrix)


DesignPoint=function(x)
{
  ####################################################
  # DesignPoint                                      #
  #   input: covariate                               #
  #   output: coded design point                     #
  ####################################################
  
  ixindx=1
  z=array(dim=Design.v)
  z[1]=1
  
  for(i in 2:(Design.ncol+1))
  {
    z[i]=x[i-1]
  }
  if( Design.bInterFlag == TRUE ){
	  for(i in (Design.ncol+2):Design.v)
	  {
	    z1indx=Design.ix1[ixindx]+1
	    z2indx=Design.ix2[ixindx]+1
	    z[i]=z[z1indx]*z[z2indx]
	    ixindx=ixindx+1
	  }
  }
  return(z)
}
ApproxTargetProb = function(z)
{
  nsim = Sim.NSim
  T.pred=matrix(nrow=Sim.NSim,ncol=Design.p) 
  mu.hat.pred=z%*%Model.b.hat 
  h=(Design.nu*solve(Model.v))/((1+(t(z)%*%solve(Model.D)%*%t(t(z))))[1,1])
  W.pred=rmvnorm(nsim,rep(0,Design.p),solve(h))
  U.pred=rchisq(nsim,Design.nu)
  
  if( nsim <= 10000)
  {
    U.pred.diag = diag(1.0 / sqrt( U.pred ) )
    T.pred = U.pred.diag %*% W.pred * sqrt(Design.nu)
  }
  else
  {
    for( i in 1:nsim )
    {
      W.pred[i,]= W.pred[i,]/sqrt( U.pred[i] ) 
    }
    T.pred = W.pred * sqrt(Design.nu) 
  }  
  for( j in 1:Design.p )
  {
    T.pred[,j] = T.pred[,j] + mu.hat.pred[1,j]
  }
  
  temp.s= rep(1, nsim)
  for(j in 1:Design.p)
  {
    temp.indices = which(! ( (T.pred[,j] < 0  & Design.YTarget[j] == 0) |  (T.pred[,j] >0  & Design.YTarget[j] == 1) ) )
    temp.s[temp.indices] =  0
  }  
  return (sum(temp.s)/nsim)
}
objFunc=function(x)
{
  #######################################
  # objective function for minimization #
  #######################################
  
  fnval = ApproxTargetProb(DesignPoint(x))
  return ( (-1.0)*fnval )
}
NumericalSearch=function()
{
  ######################################
  # NumericalSearch                    #
  ######################################
  
  start <-  as.vector(rep(0, Design.ncol))
  lower <- as.vector(rep(-1, Design.ncol))
  upper <- as.vector(rep(1, Design.ncol))
  matrix.par = matrix(nrow=Sim.NToRun,ncol=Design.ncol)
  
  OptObj <- optim( start, objFunc, method = "L-BFGS-B", lower=lower, upper=upper ) 
  
  return(OptObj)
  
}
RandomSearch=function(nsearch)
{
  ######################################
  # RandomSearch                       #
  ######################################
  
  ncol=Design.ncol
  maxprob=-1
  for(k1 in 1:nsearch)
  {
    z=runif(ncol,-1,1)
    prob=ApproxTargetProb(DesignPoint(z))
    if(prob>maxprob){
      maxprob=prob
      maxz=z
    }
  }
  RandSimObj <- list(maxprob=maxprob, maxz=maxz)
  return(RandSimObj)
}
GridSearch=function()
{
  nFac=Design.ncol
  sizes=rep( GridSearch.NoPoints, nFac )
  indices=rep(1,nFac)
  NIter=prod(sizes)  
  
  facmin=rep(-1,nFac)
  facmax=rep(1,nFac)
  steps= 2/(sizes-1)
  x=rep(0,nFac)
  maxprob=-1
  xmax=x
  
  for(i in 1:NIter)
  {
    if(bDisplayInfo==TRUE){
      cat("i: ", i, "combination: ")
      for( k in nFac:1 ){
        temp = facmin[k]+ (indices[k]-1)*steps[k]
        cat( temp, " " )
      }
      cat("\n")
    }
    
    for( k in nFac:1 ){
      x[k] = facmin[k]+ (indices[k]-1)*steps[k]
    }
    
    prob=ApproxTargetProb(DesignPoint(x))
    
    if(prob>maxprob){
      maxprob=prob
      xmax=x
    }
    
    for( k in 1:nFac ){
      if(indices[k]==sizes[k]){
        indices[k]=1;
      }
      else{
        indices[k]=indices[k]+1
        break;
      }
    }
  }
  
  GResult = list(maxprob=maxprob, xmax=xmax)
  return(GResult)
  
}
ScaledToRaw = function(z)
{
  ###########################################
  # ScaledToRaw                             #
  #   Inputs: covariate, x, coded on -1/+1  #
  #   Outputs: raw covariate                #
  ###########################################
  
  x =  as.vector(rep(0, Design.ncol))
  for (i in 1:Design.ncol)  
  {
    x[i]  = (z[i] +1 ) / 2 * (Design.Max[i]-Design.Min[i]) + Design.Min[i]
  }
  return(x)
}
MSRI = function(mA)
{
  ei = eigen(mA)
  d = ei$values
  d = (d+abs(d))/2
  d2 = 1/sqrt(d)
  d2[d == 0] = 0
  return(ei$vectors %*% diag(d2) %*% t(ei$vectors))
}
TargetProbabilityPlot = function()
{
  g.g <- UserParam.NoGraphGridPts
  Graph.fixed.1 <- UserParam.Factor1
  Graph.fixed.2 <- UserParam.Factor2
  fixed.f.size <- Design.ncol
  Graph.fixed.f <- rep(NA_real_, fixed.f.size)
  Graph.fixed.f[setdiff(1:fixed.f.size, c(Graph.fixed.1, Graph.fixed.2))] <- UserParam.GraphFixedFactors
  
  for(i in 1:(dim(data)[2]-Design.p))
  {
    if(i!=Graph.fixed.1 && i!=Graph.fixed.2)
    {
      Graph.fixed.f[i]=(2*(Graph.fixed.f[i]-min(data[,i]))/(max(data[,i])-min(data[,i])))-1
    }
  }
  
  Graph.x=array( dim = g.g * g.g ) 
  Graph.y=array( dim = g.g * g.g )
  Graph.z=array( dim = g.g * g.g )
  Graph.index=1
  
  z=array(dim=Design.ncol)
  
  for(k1 in 1:g.g)
  {
    for(k2 in 1:g.g)
    {
      z[Graph.fixed.1]=-1+(2.0/(g.g-1)*(k1-1))
      z[Graph.fixed.2]=-1+(2.0/(g.g-1)*(k2-1))
      
      for(i in 1:(Design.ncol))
      {
        if(i!=Graph.fixed.1 && i!=Graph.fixed.2){
          z[i]=Graph.fixed.f[i]
        }
      }
      zRaw=ScaledToRaw(z)
      Graph.x[Graph.index]=zRaw[Graph.fixed.1] 
      Graph.y[Graph.index]=zRaw[Graph.fixed.2]
      Graph.z[Graph.index]=ApproxTargetProb(DesignPoint(z))
      Graph.index=Graph.index+1
    }
  }
  RetObj <- list(Graph.x, Graph.y, Graph.z)
  names(RetObj) <- c("Graph.x", "Graph.y", "Graph.z")
  return (RetObj)
}

ConvertCommaSeparatedStringToNumericList=function(inputstring){
	return ( as.double( unlist(strsplit(inputstring, split=",")) ) )
}


bDisplayInfo = TRUE

########################################################
# user input                                           #
########################################################

###############################
# data & variable selections  #
###############################

UserParam.Data = ActiveDataSet
UserParam.ResponseVector = attr(UserParam.Data, "CategoricalDependent")
UserParam.InputVector = attr(UserParam.Data, "ContinuousPredictor")

depCatVar = UserParam.ResponseVector

Design.p=length(depCatVar)
if( Design.p < 1 ) {
  stop("Select at least one categorical response variable")
}
if( Design.p > 100 ){
  stop("Select fewer than 100 continuous response variables")
}

if( bDisplayInfo == TRUE ){
  depCatVar  
}

predContVar = UserParam.InputVector
Design.ncol=length(predContVar)
if( Design.ncol < 1 ) {
  stop("Select at least one continuous predictor variable")
}
if( Design.ncol > 100) {
  stop("Select fewer than 100 continuous predictor variables")
}
if( bDisplayInfo == TRUE){
  predContVar
}
predVar=predContVar


data=UserParam.Data[,c(predVar, depCatVar)]

if( bDisplayInfo == TRUE ){
  data
}

nr  =  nrow(data)
nc  = ncol(data)
origNames = names(data)
colNames = make.names(origNames)
colNames = gsub(" ", ".", colNames, fixed = TRUE)
colnames(data) = colNames

depCatVar = seq(Design.ncol+1, Design.ncol + Design.p)
predConVar = seq(1, Design.ncol)
predVarOrigCopy = predVar
predVar = seq(1, Design.ncol)

################
# Quick		   #	
################


UserParam.sInteractions = DMI_DESIGNINTERACTIONTERMS
UserParam.bNodeSetsNSim = DMI_NODEDETERMINESNUMSIMFLAG

if( UserParam.bNodeSetsNSim == FALSE ){
	UserParam.NSim = DMI_NUMBEROFSIMULATIONS
	if( UserParam.NSim < 1 || UserParam.NSim > 1000000 ) {
	  stop("Number of simulations must be between 1 and 1000000") 
	} 
	Sim.NSim = UserParam.NSim
}else{
	Sim.NSim = 1000 * Design.p
}

UserParam.OptimizationMethod = DMI_OPTIMIZATION_METHOD # (1:Numerical search, 2: Grid search, 3: Random search)
iOptMethod = UserParam.OptimizationMethod 


UserParam.TargetResponseVector = DMI_TARGETRESPONSEVECTOR
Design.YTarget = ConvertCommaSeparatedStringToNumericList( UserParam.TargetResponseVector )

if( length( Design.YTarget ) != Design.p ){
	stop("Review Target response vector for correctness")
}

temp = which(! ( Design.YTarget == 0 | Design.YTarget == 1) )
if( length( temp ) > 0 )  {
	stop("Review Target response vector for correctness")
}


#################
# Grid          #
#################

UserParam.GridSearchNoPoints = DMI_GRIDSEARCH_NOPOINTS
if( UserParam.OptimizationMethod == 2 ){ 
  if( UserParam.GridSearchNoPoints < 2 || UserParam.GridSearchNoPoints > 10 ){
    stop("Number of grid points per factor must be between 2 and 10")
  }
}

#################
# Random 		#
#################

UserParam.NumberOfRandomFactorPoints = DMI_RANDOMSEARCH_NUMRANDPOINTS
UserParam.NumberOfRandomFactorPoints
if( UserParam.OptimizationMethod == 3 ){
  if( UserParam.NumberOfRandomFactorPoints < 1 || UserParam.NumberOfRandomFactorPoints > 1000000 ){
    stop("Number of random factor points must be between 1 and 1000000") 
  }
}
NRandFactorPoints = UserParam.NumberOfRandomFactorPoints 

###########################
#	MCMC				  #
###########################
UserParam.bNodeDeterminesNumMCMCBurninFlag=DMI_NODEDETERMINESNUMMCMCBURNINFLAG
UserParam.NumberOfMCMCSimulations=DMI_NUMBEROFMCMCSIMULATIONS
UserParam.NumberOfBurnIns=DMI_NUMBEROFBURNINS

if(UserParam.bNodeDeterminesNumMCMCBurninFlag==TRUE){
	MCMC.NSim=10000
	MCMC.NBurnIns=8000
}else{
	MCMC.NSim=UserParam.NumberOfMCMCSimulations
	MCMC.NBurnIns=UserParam.NumberOfBurnIns
}


#########################
#  Graph Options    	#
#########################

UserParam.Factor1 = DMI_GRAPHFACTORX 
UserParam.Factor2 = DMI_GRAPHFACTORY 

UserParam.Factor1 = which( colNames == UserParam.Factor1 )
if( length ( UserParam.Factor1 ) == 0 ){
  stop("Review Factor for X-axis for correctness")
}

if( UserParam.Factor1 > Design.ncol ){
  stop("Review Factor for X-axis for correctness")
} 

UserParam.Factor2 = which( colNames == UserParam.Factor2 )
if( length ( UserParam.Factor2 ) == 0 ){
  stop("Review Factor for Y-axis for correctness")
}

if( UserParam.Factor2 > Design.ncol ){
  stop("Review Factor for Y-axis for correctness")
} 

UserParam.NoGraphGridPts = DMI_NUMBEROFGRAPHGRIDPARTITIONS
if( UserParam.NoGraphGridPts < 1 || UserParam.NoGraphGridPts > 1000000){
  stop("Review number of grid points per factor for correctness")
}
GridSearch.NoPoints = UserParam.GridSearchNoPoints


UserParam.GraphSetFixedFactorsToMean = DMI_SETGRAPHFIXEDFACTORTOMEANFLAG
if( UserParam.GraphSetFixedFactorsToMean == FALSE ){
	UserParam.GraphFixedFactors = ConvertCommaSeparatedStringToNumericList( DMI_GRAPHFIXEDFACTORSTRING )
	if( length(UserParam.GraphFixedFactors) != Design.ncol - 2 ){
	  stop("Review fixed factors for graphs for correctness")
	}
}

#########################
# Advanced options 		
#########################

UserParam.RandomSeed = DMI_RANDOMSEED
if( UserParam.RandomSeed <= 0 ) {
  stop("Review random seed for correctness")
}

RandomSeed = UserParam.RandomSeed

UserParam.RandomSeedFlag = DMI_RANDOMSEEDFLAG
if( UserParam.RandomSeedFlag == TRUE ){
	set.seed( RandomSeed )
}

###############################
# process interaction terms   #
###############################

TwoWayString = UserParam.sInteractions
TwoWayStringList = unlist(strsplit(TwoWayString,",",fixed=T))
N = length(TwoWayStringList)

intr=N
Design.ix1=NULL
Design.ix2=NULL

if( N > 0 ){
	Design.bInterFlag = TRUE
	for(i in 1:N)
	{
	  Effect<-(TwoWayStringList[[i]][1])
	  Effect<-gsub("\\s", "", Effect) 
	  if( bDisplayInfo == TRUE ){
	    print(Effect)
	  }
	  EffectList <- unlist(strsplit(Effect,"*",fixed=T))
	  K <- length(EffectList)
	  for(j in 1:K)
	  {
	    Pred <- EffectList[[j]][1]
	    PredNo <- as.integer( gsub("v",x=Pred,"") )
	    if( bDisplayInfo == TRUE ){
	      print(PredNo)
	      PredNo = which( predVarOrigCopy == PredNo )
	      if( length( PredNo ) == 0  ) {
	        stop("Review interaction terms for correctness.")
	      }
	      print(PredNo)
	    }
	    if(j==1)
	      Design.ix1=c(Design.ix1,PredNo)
	    if(j==2)
	      Design.ix2=c(Design.ix2,PredNo)
	  } 
	}
}else{
	Design.bInterFlag = FALSE
}

################################
# Setup design matrix          #
################################

Design.y=data.matrix(data[,depCatVar])
Design.X=data.matrix(data[,predVar])
data=data.matrix(cbind(Design.X,Design.y))


for ( i in 1:Design.p ){
	temp.unique.y = unique(Design.y[,i])
	if ( length( temp.unique.y ) > 2 ) {
		stop("Check response variables for appropriate values")
	}
	temp=which( (temp.unique.y != 0) & (temp.unique.y != 1)) 
	if( length(temp) > 0 ){
		stop("Check response variables for appropriate values")
	}
}

Design.X
Design.y

if(bDisplayInfo==TRUE){
  	data  
}

Design.ncol=ncol(data)
Design.n=nrow(data)
Design.v=1+(Design.ncol-Design.p)+intr
Design.ncol=Design.ncol-Design.p

#scale the data to [-1,1] interval
data1=matrix(nrow=Design.n,ncol=Design.ncol)

Design.Min = apply(data,2,min)
Design.Max = apply(data,2,max)

Design.Mean = apply(data,2,mean)

if( UserParam.GraphSetFixedFactorsToMean == TRUE ){
	temp.indices = which(  ( predVar != UserParam.Factor1 ) & ( predVar != UserParam.Factor2 ) )
	UserParam.GraphFixedFactors = Design.Mean[temp.indices]
}

Design.Range = Design.Max-Design.Min
temp.indices = which(Design.Range == 0)
if(sum(temp.indices) > 0){    
	stop(c("Invariant predictor columns found in data\nReview following variables:\n", paste0(colNames[temp.indices], collapse=", ")))
}

for(i in 1:Design.ncol)
{
  data1[,i]=( 2* (data[,i]-Design.Min[i])/(Design.Max[i]-Design.Min[i]))-1.0
}
Design.zx=matrix(nrow=Design.n,ncol=Design.v)
for(i in 1:Design.v)
{
  if(i==1)
    Design.zx[,i]=rep(1,Design.n)
  if(i>1 && i<=(Design.ncol+1))
    Design.zx[,i]=data1[,(i-1)]
  if(i>(Design.ncol+1))
    Design.zx[,i]=data1[,Design.ix1[i-(Design.ncol+1)]]*data1[,Design.ix2[i-(Design.ncol+1)]]
}

Model.D=0
Model.D=t(Design.zx)%*%Design.zx
Model.b=matrix(nrow=Design.v,ncol=Design.p)
Model.T=matrix(nrow=Design.n,ncol=Design.p)
Model.I=diag(1,Design.p)
Model.IX=IX=diag(1,Design.n) 

Model.T=rmvnorm(Design.n,rep(0,Design.p),Model.I)

for(iycol in 1:Design.p)
{
  
  temp.indices = which( Model.T[,iycol] > 3 )
  Model.T[temp.indices, iycol] = 3
  
  temp.indices = which( Model.T[,iycol] < -3 )
  Model.T[temp.indices, iycol] = -3
  
  temp.indices = which( Design.y[,iycol] == 0 )
  Model.T[temp.indices, iycol] = abs( Model.T[temp.indices, iycol] ) * (-1)
  
  temp.indices = which( Design.y[,iycol] == 1)
  Model.T[temp.indices, iycol] = abs( Model.T[temp.indices, iycol] ) 
}

Design.nu = Design.n-Design.p-Design.v+1 
Model.InfoMat = ginv( t(Design.zx)%*% Design.zx )
Model.sum.b=0
Model.sum.b.hat=0
Model.sum.v=0
Model.sum.Sig=0
Model.b.hat=0

################################################################################
# MCMC for computation
##############################################################################


for(MCMC_index in 1:MCMC.NSim)
{
  lmobj = lm(Model.T~Design.zx-1)
  Model.b.hat = matrix(unlist(lmobj$coef), ncol=Design.p, byrow=FALSE) 
  Model.res=lmobj$residuals 
  Model.VMat=t(Model.res)%*%Model.res
  Model.Sig=ginv(rwish((Design.n-Design.v),Model.VMat))
  Model.Sig.half=ginv(MSRI(Model.Sig))

  for(i in 1:Design.p)
  {
    Model.b[,i]=rmvnorm(1,rep(0,Design.v),Model.InfoMat) 
  }
  
  Model.b=t(Model.Sig.half%*%t(Model.b))+Model.b.hat
  Model.mu.hat=Design.zx%*%Model.b
  
  for(i in 1:Design.n)
  {
    Model.T[i,]=rmvnorm(1,Model.mu.hat[i,],Model.Sig)
  }

  for(iycol in 1:Design.p)
  {
  
    temp.indices = which( Model.T[,iycol] > 3 )
    Model.T[temp.indices, iycol] = 3
    
    temp.indices = which( Model.T[,iycol] < -3 )
    Model.T[temp.indices, iycol] = -3

    temp.indices = which( Design.y[,iycol] == 0 )
    Model.T[temp.indices, iycol] = abs( Model.T[temp.indices, iycol] ) * (-1)
    
    temp.indices = which( Design.y[,iycol] == 1)
    Model.T[temp.indices, iycol] = abs( Model.T[temp.indices, iycol] ) 
  }
  
  if(MCMC_index>MCMC.NBurnIns)
  {
    Model.sum.b=Model.sum.b+Model.b
    Model.sum.b.hat=Model.sum.b.hat+Model.b.hat
    Model.sum.v=Model.sum.v+Model.VMat
    Model.sum.Sig=Model.sum.Sig+Model.Sig
  }
}  

# finalize estimates #
scalefac = 1.0 / (MCMC.NSim-MCMC.NBurnIns)
Model.post.b=Model.sum.b * scalefac 
Model.post.Sig=Model.sum.Sig * scalefac
Model.b.hat=Model.sum.b.hat * scalefac
Model.v=Model.sum.v * scalefac

if(bDisplayInfo==TRUE){
  Model.post.b
  Model.post.Sig
  Model.b.hat
}

#####################################################
# Optimization of target probabilities              #
#####################################################
if( iOptMethod == 1 ) {
	# Numerical search ( L-BFGS-B ) #
	Sim.NToRun = 5 # used by NumericalSearch
	NumObj = NumericalSearch()
	optpoint = NumObj$par
	maxprob = NumObj$value * (-1)
	
} else if (iOptMethod == 2){
	# Grid search #
	Sim.GridSearch = GridSearch()
	optpoint = Sim.GridSearch$xmax
	maxprob = Sim.GridSearch$maxprob
	

} else if (iOptMethod == 3){
	# Random search #
	Sim.RandomSearch = RandomSearch(NRandFactorPoints) 
	optpoint = Sim.RandomSearch$maxz
	maxprob = Sim.RandomSearch$maxprob
}
# Display the graphs

stitle="Bayesian Reliability Surface"
DPlot=TargetProbabilityPlot() 


wireframe(DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y, scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1],rot=30),ylab=list(colNames[UserParam.Factor2],rot=-45),zlab="Probability",main=stitle)
wireframe(DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y, scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1],rot=-40),ylab=list(colNames[UserParam.Factor2],rot=35),screen=list(z=-45,x=-60),zlab="Probability",main=stitle)
wireframe(DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y, scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1],rot=15),ylab=list(colNames[UserParam.Factor2],rot=-30),screen=list(z=-145,x=-60),zlab="Probability",main=stitle)
contourplot( DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y,region=TRUE,scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1]),ylab=list(colNames[UserParam.Factor2]),screen=list(z=-145,x=-60),zlab="Probability",main=stitle)

output = c( ScaledToRaw(optpoint), maxprob)
OutputData = data.frame(output)
row.names(OutputData)=  c(colNames[1:Design.ncol], "Maximum probability")
colnames(OutputData)= "Value"
RouteOutput(OutputData, "Results")







