Uses(stringr)
Uses(graphics)
Uses(mvtnorm)
Uses(lattice)
Uses(MASS)


DesignPoint=function(x)
{
  ####################################################
  # DesignPoint                                      #
  #   input: covariate                               #
  #   output: coded design point                     #
  ####################################################
  
  ixindx=1
  z=array(dim=Design.v)
  z[1]=1
  
  for(i in 2:(Design.ncol+1))
  {
    z[i]=x[i-1]
  }
  if( Design.bInterFlag == TRUE ){
	  for(i in (Design.ncol+2):Design.v)
	  {
	    z1indx=Design.ix1[ixindx]+1
	    z2indx=Design.ix2[ixindx]+1
	    z[i]=z[z1indx]*z[z2indx]
	    ixindx=ixindx+1
	  }
  }
  return(z)
}
ApproxPosteriorProb2=function(z)
{
  #####################################################
  # ApproxPosteriorProb2                              #
  # Computes approximate probability via simulation   #
  # Used as a test function to ensure                 #
  # all other functions that compute a posterior prob #
  # generate correct results.                         #
  #   Inputs                                          #
  #     z : coded design point                        #  
  #####################################################
  sum=0
  y.pred=matrix(nrow=Sim.nsim,ncol=Design.p)
  for(i in 1:Sim.nsim)
  {
    mu.hat.pred=z%*%Model.b.hat
    h=(Model.nu*solve(Model.v))/((1+(t(z)%*%solve(Model.D)%*%t(t(z))))[1,1])
    W.pred=rmvnorm(1,rep(0,Design.p),solve(h))
    U.pred=rchisq(1,Model.nu)
    for(j in 1:Design.p){
      y.pred[i,j]=((sqrt(Model.nu)*W.pred[1,j])/sqrt(U.pred))+mu.hat.pred[1,j]
    }
    d=1
    for(j in 1:Design.p)
    {
      if(y.pred[i,j]<Desir.L[j])
        d=d*0
      if(Desir.L[j]<=y.pred[i,j] && y.pred[i,j]<Desir.T[j])
        d=d*(((y.pred[i,j]-Desir.L[j])/(Desir.T[j]-Desir.L[j]))^(Desir.SCurvature[j]/Design.p))
      if(Desir.T[j]<=y.pred[i,j] && y.pred[i,j]<=Desir.U[j])
        d=d*(((y.pred[i,j]-Desir.U[j])/(Desir.T[j]-Desir.U[j]))^(Desir.TCurvature[j]/Design.p))
      if(y.pred[i,j]>Desir.U[j])
        d=d*0
    }
    if(d>Desir.ld)
      sum=sum+1
  }
  return (sum/Sim.nsim)
} 
ApproxPosteriorProb=function(z)
{
  ####################################################
  # ApproxPosteriorProb                              #
  #   Inputs                                         #
  #     z : coded design point                       #
  #  Output                                          #
  #    Prob(D >= Dstar|z)                            #  
  ####################################################
  
  sum = 0 
  y.pred=matrix(nrow=Sim.nsim,ncol=Design.p) 
  mu.hat.pred=z%*%Model.b.hat 
  h=(Model.nu*solve(Model.v))/((1+(t(z)%*%solve(Model.D)%*%t(t(z))))[1,1])
  nsim=Sim.nsim
  
  d=as.vector(rep(1,length=nsim))
  
  W.pred=rmvnorm(nsim,rep(0,Design.p),solve(h))
  U.pred=rchisq(nsim,Model.nu)
  
  if( nsim <= 10000)
  {
    U.pred.diag = diag(1.0 / sqrt( U.pred ) )
    y.pred = U.pred.diag %*% W.pred * sqrt(Model.nu)
  }
  else
  {
    for( i in 1:nsim )
    {
      W.pred[i,]= W.pred[i,]/sqrt( U.pred[i] ) 
    }
    y.pred = W.pred * sqrt(Model.nu) 
  }  
  
  for( j in 1:Design.p )
  {
    y.pred[,j] = y.pred[,j] + mu.hat.pred[1,j]
  }
  
  for(j in 1:Design.p)
  {
    temp.indices = which((y.pred[,j] < Desir.L[j] ) | (y.pred[,j]>Desir.U[j]))
    d [ temp.indices  ] = 0  
    
    temp.indices = which (( Desir.L[j]<=y.pred[,j]) & (y.pred[,j]<Desir.T[j]))
    d [  temp.indices  ] =  d [  temp.indices  ] * (((y.pred[temp.indices,j]-Desir.L[j])/(Desir.T[j]-Desir.L[j]))^(Desir.SCurvature[j]/Design.p))
    
    temp.indices = which( ( Desir.T[j]<=y.pred[,j]) & (y.pred[,j]<=Desir.U[j]) )
    d [ temp.indices   ] =  d [  temp.indices  ] *(((y.pred[temp.indices,j]-Desir.U[j])/(Desir.T[j]-Desir.U[j]))^(Desir.TCurvature[j]/Design.p))
    
  }
  temp.indices = which( d > Desir.ld ) 
  prob = length(temp.indices) / nsim
  
  return(prob)
  
} 
objFunc=function(x)
{
  #######################################
  # objective function for minimization #
  #######################################
  
  fnval = ApproxPosteriorProb(DesignPoint(x))
  return ( (-1.0)*fnval )
}
NumericalSearch=function()
{
  ######################################
  # NumericalSearch                    #
  ######################################
  
  start <-  as.vector(rep(0, Design.ncol))
  lower <- as.vector(rep(-1, Design.ncol))
  upper <- as.vector(rep(1, Design.ncol))
  matrix.par = matrix(nrow=Sim.NToRun,ncol=Design.ncol)
  
  OptObj <- optim( start, objFunc, method = "L-BFGS-B", lower=lower, upper=upper ) 
  
  return(OptObj)
  
}
RandomSearch=function(nsearch)
{
  ######################################
  # RandomSearch                       #
  ######################################
  
  ncol=Design.ncol
  maxprob=-1
  for(k1 in 1:nsearch)
  {
    z=runif(ncol,-1,1)
    prob=ApproxPosteriorProb(DesignPoint(z))
    if(prob>maxprob){
      maxprob=prob
      maxz=z
    }
  }
  RandSimObj <- list(maxprob=maxprob, maxz=maxz)
  return(RandSimObj)
}
GridSearch=function()
{
  nFac=Design.ncol
  sizes=rep( GridSearch.NoPoints, nFac )
  indices=rep(1,nFac)
  NIter=prod(sizes)  
    
  facmin=rep(-1,nFac)
  facmax=rep(1,nFac)
  steps= 2/(sizes-1)
  x=rep(0,nFac)
  maxprob=-1
  xmax=x
  
  for(i in 1:NIter)
  {
    if(bDisplayInfo==TRUE){
      cat("i: ", i, "combination: ")
      for( k in nFac:1 ){
        temp = facmin[k]+ (indices[k]-1)*steps[k]
        cat( temp, " " )
      }
      cat("\n")
    }
    
    for( k in nFac:1 ){
      x[k] = facmin[k]+ (indices[k]-1)*steps[k]
    }
    
    prob=ApproxPosteriorProb(DesignPoint(x))
    
    if(prob>maxprob){
      maxprob=prob
      xmax=x
    }
    
    for( k in 1:nFac ){
      if(indices[k]==sizes[k]){
        indices[k]=1;
      }
      else{
        indices[k]=indices[k]+1
        break;
      }
    }
  }
  
  GResult = list(maxprob=maxprob, xmax=xmax)
  return(GResult)
  
}
DesirabilityPlot = function()
{
  g.g <- UserParam.NoGraphGridPts
  Graph.fixed.1 <- UserParam.Factor1
  Graph.fixed.2 <- UserParam.Factor2
  fixed.f.size <- Design.ncol
  Graph.fixed.f <- rep(NA_real_, fixed.f.size)
  Graph.fixed.f[setdiff(1:fixed.f.size, c(Graph.fixed.1, Graph.fixed.2))] <- UserParam.GraphFixedFactors
  
  for(i in 1:(dim(data)[2]-Design.p))
  {
    if(i!=Graph.fixed.1 && i!=Graph.fixed.2)
    {
      Graph.fixed.f[i]=(2*(Graph.fixed.f[i]-min(data[,i]))/(max(data[,i])-min(data[,i])))-1
    }
  }
  
  Graph.x=array( dim = g.g * g.g ) 
  Graph.y=array( dim = g.g * g.g )
  Graph.z=array( dim = g.g * g.g )
  Graph.index=1
  
  z=array(dim=Design.ncol)
  

  #Graph.x[Graph.index]= Sim.NumericalSearch$par[Graph.fixed.1] 
  #Graph.y[Graph.index]= Sim.NumericalSearch$par[Graph.fixed.2]
  #Graph.z[Graph.index]= Sim.NumericalSearch$value * (-1.0) 
  #Graph.index=Graph.index+1
  
  for(k1 in 1:g.g)
  {
    for(k2 in 1:g.g)
    {
      z[Graph.fixed.1]=-1+(2.0/(g.g-1)*(k1-1))
      z[Graph.fixed.2]=-1+(2.0/(g.g-1)*(k2-1))
      
      for(i in 1:(Design.ncol))
      {
        if(i!=Graph.fixed.1 && i!=Graph.fixed.2){
          z[i]=Graph.fixed.f[i]
        }
      }
      zRaw=ScaledToRaw(z)
      Graph.x[Graph.index]=zRaw[Graph.fixed.1] 
      Graph.y[Graph.index]=zRaw[Graph.fixed.2]
      Graph.z[Graph.index]=ApproxPosteriorProb(DesignPoint(z))
      Graph.index=Graph.index+1
    }
  }
  RetObj <- list(Graph.x, Graph.y, Graph.z)
  names(RetObj) <- c("Graph.x", "Graph.y", "Graph.z")
  return (RetObj)
}
ScaledToRaw = function(z)
{
  ###########################################
  # ScaledToRaw                             #
  #   Inputs: covariate, x, coded on -1/+1  #
  #   Outputs: raw covariate                #
  ###########################################
  
  x =  as.vector(rep(0, Design.ncol))
  for (i in 1:Design.ncol)  
  {
    x[i]  = (z[i] +1 ) / 2 * (Design.Max[i]-Design.Min[i]) + Design.Min[i]
  }
  return(x)
}

ConvertCommaSeparatedStringToNumericList=function(inputstring){
  return ( as.double( unlist(strsplit(inputstring, split=",")) ) )
}


# End of function definitions
###################################################################################

bDisplayInfo = TRUE

########################################################
# user input                                           #
########################################################

###############################
# data & variable selections  #
###############################

UserParam.Data = ActiveDataSet
UserParam.ResponseVector = attr(UserParam.Data, "ContinuousDependent")
UserParam.InputVector = attr(UserParam.Data, "ContinuousPredictor")

depContVar = UserParam.ResponseVector

Design.p=length(depContVar)
if( Design.p < 1 ) {
  stop("Select at least one continuous response variable")
}
if( Design.p > 100 ){
  stop("Select fewer than 100 continuous response variables")
}

if( bDisplayInfo == TRUE ){
  depContVar  
}

predContVar = UserParam.InputVector
Design.ncol=length(predContVar)
if( Design.ncol < 1 ) {
  stop("Select at least one continuous predictor variable")
}
if( Design.ncol > 100) {
  stop("Select fewer than 100 continuous predictor variables")
}

if( bDisplayInfo == TRUE){
  predContVar
}
predVar=predContVar


data=UserParam.Data[,c(predVar, depContVar)]

if( bDisplayInfo == TRUE ){
  data
}

nr  =  nrow(data)
nc  = ncol(data)
origNames = names(data)
colNames = make.names(origNames)
colNames = gsub(" ", ".", colNames, fixed = TRUE)
colnames(data) = colNames

depContVar = seq(Design.ncol+1, Design.ncol + Design.p)
predConVar = seq(1, Design.ncol)
predVarOrigCopy = predVar
predVar = seq(1, Design.ncol)

################
# Quick		   #	
################

UserParam.sInteractions = DMI_DESIGNINTERACTIONTERMS
UserParam.bNodeSetsNSim = DMI_NODEDETERMINESNUMSIMFLAG

if( UserParam.bNodeSetsNSim == FALSE ){
	UserParam.NSim = DMI_NUMBEROFSIMULATIONS
	if( UserParam.NSim < 1 || UserParam.NSim > 1000000 ) {
	  stop("Number of simulations must be between 1 and 1000000") 
	} 
	Sim.nsim = UserParam.NSim
}else{
	Sim.nsim = 1000 * Design.p
}
Sim.nsim
UserParam.OptimizationMethod = DMI_OPTIMIZATION_METHOD # (1:Numerical search, 2: Grid search, 3: Random search)
iOptMethod = UserParam.OptimizationMethod 

#################
# Grid          #
#################

UserParam.GridSearchNoPoints = DMI_GRIDSEARCH_NOPOINTS
if( UserParam.OptimizationMethod == 2 ){ 
  if( UserParam.GridSearchNoPoints < 2 || UserParam.GridSearchNoPoints > 10 ){
    stop("Number of grid points per factor must be between 2 and 10")
  }
}

#################
# Random 		#
#################

UserParam.NumberOfRandomFactorPoints = DMI_RANDOMSEARCH_NUMRANDPOINTS
if( UserParam.OptimizationMethod == 3 ){
  if( UserParam.NumberOfRandomFactorPoints < 1 || UserParam.NumberOfRandomFactorPoints > 1000000 ){
    stop("Number of random factor points must be between 1 and 1000000") 
  }
}
NRandFactorPoints = UserParam.NumberOfRandomFactorPoints 

###########################
# Desirability parameters #
###########################

UserParam.LowerBoundForDesirabilityFunction = DMI_LOWERBOUNDFORDESIRABILITYFUNCTIONSTRING
UserParam.UpperBoundForDesirabilityFunction = DMI_UPPERBOUNDFORDESIRABILITYFUNCTIONSTRING
UserParam.TargetForDesirabilityFunction = DMI_TARGETFORDESIRABILITYFUNCTIONSTRING
UserParam.LowerDesirabilityLimit = DMI_DESIRABILITYTHRESHOLD
UserParam.SForDesirability = DMI_DESIRABILITY_S_STRING
UserParam.TForDesirability = DMI_DESIRABILITY_T_STRING

Desir.L = ConvertCommaSeparatedStringToNumericList( UserParam.LowerBoundForDesirabilityFunction )
Desir.U = ConvertCommaSeparatedStringToNumericList( UserParam.UpperBoundForDesirabilityFunction )
Desir.T = ConvertCommaSeparatedStringToNumericList( UserParam.TargetForDesirabilityFunction )
Desir.SCurvature = ConvertCommaSeparatedStringToNumericList(UserParam.SForDesirability)
Desir.TCurvature = ConvertCommaSeparatedStringToNumericList(UserParam.TForDesirability)

if( !( length( Desir.L ) == length( Desir.U ) &&  length( Desir.L ) == length( Desir.T)  ) ){	
  stop("Check desirability parameters for correctness")
}
if( ( length( Desir.L ) != Design.p ) ){
  stop("Check desirability parameters for correctness")
}

if( length ( Desir.SCurvature ) != length ( Desir.TCurvature ) ) {
  stop("Check desirability parameters for correctness")
}

if ( length( Desir.SCurvature ) != Design.p ){
  stop("Check desirability parameters for correctness")
}

Desir.ld =  UserParam.LowerDesirabilityLimit 
if( Desir.ld <= 0 || Desir.ld >= 1){
  stop("Desirability threshold must be in the interval (0,1)")
} 

#########################
#  Graph Options    	#
#########################

UserParam.Factor1 = DMI_GRAPHFACTORX 
UserParam.Factor2 = DMI_GRAPHFACTORY 

UserParam.Factor1 = which( colNames == UserParam.Factor1 )
if( length ( UserParam.Factor1 ) == 0 ){
  stop("Review Factor for X-axis for correctness")
}

if( UserParam.Factor1 > Design.ncol ){
  stop("Review Factor for X-axis for correctness")
} 

UserParam.Factor2 = which( colNames == UserParam.Factor2 )
if( length ( UserParam.Factor2 ) == 0 ){
  stop("Review Factor for Y-axis for correctness")
}

if( UserParam.Factor2 > Design.ncol ){
  stop("Review Factor for Y-axis for correctness")
} 

UserParam.NoGraphGridPts = DMI_NUMBEROFGRAPHGRIDPARTITIONS
if( UserParam.NoGraphGridPts < 1 || UserParam.NoGraphGridPts > 1000000){
  stop("Review number of grid points per factor for correctness")
}
GridSearch.NoPoints = UserParam.GridSearchNoPoints


UserParam.GraphSetFixedFactorsToMean = DMI_SETGRAPHFIXEDFACTORTOMEANFLAG

if( UserParam.GraphSetFixedFactorsToMean == FALSE ){
	UserParam.GraphFixedFactors = ConvertCommaSeparatedStringToNumericList( DMI_GRAPHFIXEDFACTORSTRING )
	if( length(UserParam.GraphFixedFactors) != Design.ncol - 2 ){
	  stop("Review fixed factors for graphs for correctness")
	}
}


#########################
# Advanced options 		#
#########################

UserParam.RandomSeed = DMI_RANDOMSEED
if( UserParam.RandomSeed <= 0 ) {
  stop("Review random seed for correctness")
}

RandomSeed = UserParam.RandomSeed

UserParam.RandomSeedFlag = DMI_RANDOMSEEDFLAG
if( UserParam.RandomSeedFlag == TRUE ){
	set.seed( RandomSeed )
}


###############################
# process interaction terms   #
###############################

TwoWayString = UserParam.sInteractions
TwoWayStringList = unlist(strsplit(TwoWayString,",",fixed=T))
N = length(TwoWayStringList)
N
intr=N
Design.ix1=NULL
Design.ix2=NULL

if( N > 0){
    Design.bInterFlag = TRUE
	for(i in 1:N)
	{
	  Effect<-(TwoWayStringList[[i]][1])
	  Effect<-gsub("\\s", "", Effect) 
	  if( bDisplayInfo == TRUE ){
	    print(Effect)
	  }
	  EffectList <- unlist(strsplit(Effect,"*",fixed=T))
	  K <- length(EffectList)
	  for(j in 1:K)
	  {
	    Pred <- EffectList[[j]][1]
	    PredNo <- as.integer( gsub("v",x=Pred,"") )
	    if( bDisplayInfo == TRUE ){
	      print(PredNo)
	      PredNo = which( predVarOrigCopy == PredNo )
	      if( length( PredNo ) == 0  ) {
	        stop("Review interaction terms for correctness.")
	      }
	      print(PredNo)
	    }
	    if(j==1)
	      Design.ix1=c(Design.ix1,PredNo)
	    if(j==2)
	      Design.ix2=c(Design.ix2,PredNo)
	  } 
	}
}else{
	Design.bInterFlag = FALSE
}
################################
# Setup design matrix          #
################################

Design.y=data.matrix(data[,depContVar])
Design.X=data.matrix(data[,predVar])
data=data.matrix(cbind(Design.X,Design.y))

Design.X
Design.y

if(bDisplayInfo==TRUE){
  data  # design matrix
}

Design.ncol=ncol(data)
Design.n=nrow(data)
Design.v=1+(Design.ncol-Design.p)+intr
Design.ncol=Design.ncol-Design.p

#scale the data to [-1,1] interval
data1=matrix(nrow=Design.n,ncol=Design.ncol)

Design.Min = apply(data,2,min)
Design.Max = apply(data,2,max)
Design.Mean = apply(data,2,mean)

if( UserParam.GraphSetFixedFactorsToMean == TRUE ){
	temp.indices = which(  ( predVar != UserParam.Factor1 ) & ( predVar != UserParam.Factor2 ) )
	UserParam.GraphFixedFactors = Design.Mean[temp.indices]
}

Design.Range = Design.Max-Design.Min
temp.indices = which(Design.Range == 0)
if(sum(temp.indices) > 0){    
	stop(c("Invariant predictor columns found in data\nReview following variables:\n", paste0(colNames[temp.indices], collapse=", ")))
}
for(i in 1:Design.ncol)
{
  data1[,i]=( 2* (data[,i]-Design.Min[i])/(Design.Max[i]-Design.Min[i]))-1.0
}
Design.zx=matrix(nrow=Design.n,ncol=Design.v)
for(i in 1:Design.v)
{
  if(i==1)
    Design.zx[,i]=rep(1,Design.n)
  if(i>1 && i<=(Design.ncol+1))
    Design.zx[,i]=data1[,(i-1)]
  if(i>(Design.ncol+1))
    Design.zx[,i]=data1[,Design.ix1[i-(Design.ncol+1)]]*data1[,Design.ix2[i-(Design.ncol+1)]]
}

#####################################################
# Compute model terms, parameter estimates, etc.    #
#####################################################

Model.D=0
Model.D=t(Design.zx)%*%Design.zx
Model.nu=Design.n-Design.p-Design.v+1
lmobj = lm(Design.y~Design.zx-1)
Model.b.hat = matrix(unlist(lmobj$coef), ncol=Design.p, byrow=FALSE) 
Model.b.hat[is.na(Model.b.hat)] = 0 # set zeroed out parameters to zero 
colnames(Model.b.hat) = colnames(Design.y) 
Model.res=lmobj$residuals 
Model.v=t(Model.res)%*%Model.res

if( bDisplayInfo == TRUE ){
  Model.b.hat
}

#####################################################
# Optimization of posterior probabilities           #
#####################################################



if( iOptMethod == 1 ) {
  # Numerical search ( L-BFGS-B ) #
  Sim.NToRun = 5 # used by NumericalSearch
  Sim.NumericalSearch<-NumericalSearch()
  optpoint=Sim.NumericalSearch$par
  maxprob=Sim.NumericalSearch$value * (-1)
} else if (iOptMethod == 2){
  # Grid search #
  Sim.GridSearch = GridSearch()
  optpoint = Sim.GridSearch$xmax
  maxprob = Sim.GridSearch$maxprob
} else if (iOptMethod == 3){
  # Random search #
  Sim.RandomSearch = RandomSearch(NRandFactorPoints) 
  optpoint = Sim.RandomSearch$maxz
  maxprob = Sim.RandomSearch$maxprob
}

# Display the graphs
stitle="Bayesian Reliability Surface"
DPlot=DesirabilityPlot() 

wireframe(DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y, scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1],rot=30),ylab=list(colNames[UserParam.Factor2],rot=-45),zlab="Probability",main=stitle)
wireframe(DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y, scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1],rot=-40),ylab=list(colNames[UserParam.Factor2],rot=35),screen=list(z=-45,x=-60),zlab="Probability",main=stitle)
wireframe(DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y, scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1],rot=15),ylab=list(colNames[UserParam.Factor2],rot=-30),screen=list(z=-145,x=-60),zlab="Probability",main=stitle)
contourplot( DPlot$Graph.z ~ DPlot$Graph.x * DPlot$Graph.y,region=TRUE,scales = list(arrows = FALSE), drape=TRUE,colorkey=TRUE,col="lightseagreen",xlab =list(colNames[UserParam.Factor1]),ylab=list(colNames[UserParam.Factor2]),screen=list(z=-145,x=-60),zlab="Probability",main=stitle)

output = c(ScaledToRaw(optpoint), maxprob)
OutputData = data.frame(output)
row.names(OutputData)=  c(colNames[1:Design.ncol], "Maximum probability")
colnames(OutputData)= "Value"
RouteOutput(OutputData, "Results")
