#r "..\..\STATISTICA.Core.Interop.dll"
#r "..\..\STATISTICA.DataMiner.Interop.dll"
#r "..\..\sta_net_DMModel.dll"
#r "..\..\sta_net_DMViewModel.dll"
#r "..\..\GenericCodeNode.dll"
#r "System.Xml.dll"
#r "..\..\PropertyGridHelper.dll"

using System.Runtime.InteropServices;
using StatSoft.DataMinerNodes.Model;
using StatSoft.DataMinerNodes.ViewModel;
using System.Xml.Serialization;
using System.IO;
using System.Xml;
using System.Collections.Generic;
using GenericCodeNode;
using PropertyGridHelper;
using STATISTICA;

public class ALS
{
	static double Version {get{return 1.0;}}
	
	static void CheckVersion(double version)
	{
		if(version > Version)
			throw new Exception(string.Format("Node is newer version {0} and cannot run with version {1} code", version, Version));
		if(version < Version)
			throw new Exception(string.Format("Node is older version {0} and cannot run with version {1} code", version, Version));
	}
	
	public static void BuildModel(double version, dynamic Host, dynamic InputContainer, dynamic OutputContainer, out object DownstreamDocument)
	{
		CheckVersion(version);
		DownstreamDocument = null;
		var ParametersCollection = SupportFunctions.GetPropertyCollections(Host);			
		int rank = (int)ParametersCollection["Quick"]["parameter_rank"];            //Define the desired rank (choose between: 1 - 1000)
		int nc = (int)ParametersCollection["Advanced"]["parameter_nc"];              //Define the number of chunks for the multithreading (TBD: do not choose more than 16 for now)
		int maxit = (int)ParametersCollection["Advanced"]["parameter_maxit"];        //Define maximum umber of iterations (choose between: 1000 - 10000)
		double lam = (double)ParametersCollection["Quick"]["parameter_Lambda"];             //Define a positive value for the penalization parameter lambda (choose between: TBD; for now, do not choose very large &gt; 10000)
		double tol = (double)ParametersCollection["Advanced"]["parameter_tol"];           //Choose between 0 and 1. 0: Frobenious norm, 1: MSE
		int ws = (int)ParametersCollection["Warm Start"]["parameter_ws"];              //Choose between 0 and 1. 0: no warm start, 1: do warm start. Donot change it to 1 for now.
		int grid = (int)ParametersCollection["Quick"]["parameter_grid"];            //Choose between 0 and 1. 0: no lambda grid, 1: do lambda grid.
		double gridstart = (double)ParametersCollection["Quick"]["parameter_gs"];       //Choose any positive value &gt; 0. Only effective if grid = 1.
		int ngridpoints = (int)ParametersCollection["Quick"]["parameter_ng"];    //Choose any positive integer &gt; 1. Only effective if grid = 1.
		int bisection = (int)ParametersCollection["Quick"]["parameter_bisec"];     //Choose between 0 and 1. 0: Don//t use bisection, 1: Use bisection.
		int rsorted = (int)ParametersCollection["Quick"]["parameter_rsorted"];     //Choose between 0 and 1. 0: unsorted , 1: Row-sorted.
		int nss = (int)ParametersCollection["Result"]["parameter_nss"];     //Choose between 0 and 1. 0: A, B, D in a single spreadsheet, 1: A, B, D in three different spreadsheet.
		int sparse = (int)ParametersCollection["Quick"]["parameter_sparse"];     //Choose between 0 and 1. 0: Incomplete, 1: Sparse.
		int svec = (int)ParametersCollection["Result"]["parameter_svec"];     //Choose between 0 and 1. 0: show A, B, 1: show U, V.
		int comp = (int)ParametersCollection["Advanced"]["parameter_comp"];     //Choose between 0 and 1. 0: numeric row/ column indices, 1: non-numeric row/ column indices
		int rc = (int)ParametersCollection["Advanced"]["parameter_rc"];
		int predfull = (int)ParametersCollection["Result"]["parameter_predfull"];
		int ccolR = 0;
		int ccolC = 0;
		int ccolV = 0;
		int m = 0;
		int n = 0;
		int effr = 0;
		int rankp = rank;
		object errmsg = "";
		object ssparse = ParametersCollection["Quick"]["parameter_sparse"];
		object sgrid = ParametersCollection["Quick"]["parameter_grid"];
		object sbisection = ParametersCollection["Quick"]["parameter_bisec"];
		object src = ParametersCollection["Advanced"]["parameter_rc"];
		string spstr = "";
		string rstr = "";
		string lamstr = "";
		string gridstr = "";
		string bistr = "";
		string rcstr = "";
		string tolstr = "";


		//Algorithm requires the last singular value to be 0 for optimal non-convex optimization. Hence the r+1th singular value will make sure the algorithm has converged
		if(sparse == 0)
			rank = rank + 1;

		//Read the data from a spreadsheet
		var sm1 = InputContainer[0].DataSource;

		for(int x = 1; x <= sm1.NumberOfVariables; x++)
		{
			string st = (string)ParametersCollection["Quick"]["parameter_ccolR"];
			if(string.Equals(sm1.VariableName[x], st.Trim('"')))
			ccolR = x;
		}
		for(int x = 1; x <= sm1.NumberOfVariables; x++)
		{
			string st = (string)ParametersCollection["Quick"]["parameter_ccolC"];
			if(string.Equals(sm1.VariableName[x], st.Trim('"')))
			ccolC = x;
		}
		for(int x = 1; x <= sm1.NumberOfVariables; x++)
		{
			string st = (string)ParametersCollection["Quick"]["parameter_ccolV"];
			if(string.Equals(sm1.VariableName[x], st.Trim('"')))
			ccolV = x;
		}

		//Defining res that will produce the output
		object res = null;
		object res2 = null;
		object res3 = null;
		object res4 = null;
		object res5 = null;
		object A=null, B=null, D=null;
		
		if(ws==1)
		{
			STATISTICA.Spreadsheet[] sprs = SupportFunctions.GetModel(Host as STATISTICADataMiner.DataMinerNode);
			A = sprs[0];
			B = sprs[1];
			D = sprs[2];
		}

		//Run softImpSVD_ to get the singular values or setComplete_ to get the prediction of the missing entries over the block
		//When testing either of the functions, comment out the other one.
		//Timer has been used to track the running time for each function

		var ifault = SupportFunctions.rawDataSoftImpSVD(ref sm1, ref A, ref B, ref D, ref res, ref res2, ref res3, ref res4, ref res5, rank, nc, maxit, lam, tol, rc, grid, gridstart, ngridpoints, ws, bisection, rsorted, nss, sparse, svec, ccolR, ccolC, ccolV, comp, m, n, effr, predfull);                                         //Function generates r singular values

		//Error messages
		if(ifault != 0)
		{
			if(ifault == 2)
			{
				return;
			}
			else
			{
				SupportFunctions.StringFromCode(ref ifault, ref errmsg); 
				throw new Exception((string)(errmsg));
			}
		}

		DownstreamDocument = res3;
		object singularvals = null;
		
		var ParametersNameCollection = new Dictionary<string, Dictionary<string, string>>();
		var gcnData = Host.ParametersObject.NodeData;
		if (gcnData != null)
		{
			foreach(var tabObj in gcnData.Tabs)
			{
				if (tabObj != null && tabObj is ParametersPageData)
				{
					string sKey = tabObj.TabName;
					var tempMap = new Dictionary<string, string>();
					foreach(var kvp in tabObj.Parameters.FieldProperties)
					{
						tempMap[kvp.Key] = kvp.Value.DisplayName;
					}
					ParametersNameCollection[sKey] = tempMap;
				}
			}

			foreach(var kvp1 in ParametersNameCollection)
			{
				string key1 = "parameter_sparse"; 
				string key2 = "parameter_rank";
				string key3 = "parameter_Lambda"; 
				string key4 = "parameter_grid";
				string key5 = "parameter_bisec";
				string key6 = "parameter_rc";
				string key7 = "parameter_tol";
				foreach(var kvp2 in kvp1.Value)
				{
					if(string.Equals(kvp2.Key, key1.Trim('"')))
						spstr = kvp2.Value;
					if(string.Equals(kvp2.Key, key2.Trim('"')))
						rstr = kvp2.Value;
					if(string.Equals(kvp2.Key, key3.Trim('"')))
						lamstr = kvp2.Value;
					if(string.Equals(kvp2.Key, key4.Trim('"')))
						gridstr = kvp2.Value;
					if(string.Equals(kvp2.Key, key5.Trim('"')))
						bistr = kvp2.Value;
					if(string.Equals(kvp2.Key, key6.Trim('"')))
						rcstr = kvp2.Value;
					if(string.Equals(kvp2.Key, key7.Trim('"')))
						tolstr = kvp2.Value;
				}
			}
		}
		
		string sTemp1 = "";
		string sTemp2 = "";
		if(nss == 0)
		{
			sTemp1 = (res4 as STATISTICA.Spreadsheet).Header.Value as string;
		}
		else
		{
			sTemp1 = (res as STATISTICA.Spreadsheet).Header.Value as string;
		}
		var icode = 151;
		object parsum = "";
		SupportFunctions.StringFromCode(ref icode, ref parsum);
		sTemp2 = (string)(parsum);
		sTemp1 = sTemp2 + string.Format("\n {0}: {1}\n {2}: {3}\n {4}: {5}\n {6}: {7}\n {8}: {9}\n {10}: {11}\n {12}: {13}\n", spstr, ssparse, rstr, rankp, lamstr, lam, gridstr, sgrid, bistr, sbisection, rcstr, src, tolstr, tol) + sTemp1;
		if(nss == 0)
		{
			(res4 as STATISTICA.Spreadsheet).Header.Value = sTemp1;
			(res4 as Spreadsheet).AutoFitVariables();
			(res4 as Spreadsheet).AutoFitCase();
			OutputContainer.Add(res4);
		}
		else
		{	
			(res as STATISTICA.Spreadsheet).Header.Value = sTemp1;
			if(grid == 0)
			{
				OutputContainer.Add(res);
				OutputContainer.Add(res2);
				OutputContainer.Add(res3);
			}
			else
			{
				OutputContainer.Add(res);
				OutputContainer.Add(res2);
				OutputContainer.Add(res3);
				(res4 as Spreadsheet).AutoFitVariables();
				(res4 as Spreadsheet).AutoFitCase();
				OutputContainer.Add(res4);
			}
		}
		if(predfull == 1 && sparse == 0)
		{
			(res5 as Spreadsheet).AutoFitVariables();
			(res5 as Spreadsheet).AutoFitCase();
			OutputContainer.Add(res5);
		}
		if(svec == 0)
		{
			SupportFunctions.AddModelNode(Host, new STATISTICA.Spreadsheet[]{ res as STATISTICA.Spreadsheet, res2 as STATISTICA.Spreadsheet, res3 as STATISTICA.Spreadsheet});
		}
		singularvals = res3;
		if(singularvals != null)
		{
			OutputContainer.Add(SupportFunctions.Graph(Host, singularvals));
		}	
	}

	public static void DeployModel(double version, dynamic Host, dynamic InputContainer, dynamic OutputContainer, out object DownstreamDocument)
	{
		DownstreamDocument = null;
		STATISTICA.Spreadsheet[] sprs = SupportFunctions.GetModel(Host as STATISTICADataMiner.DataMinerNode);
		var ParametersCollection = SupportFunctions.GetPropertyCollections(Host);			
		int ccolR = 0;
		int ccolC = 0;
		int ccolV = 0;
		int ifault = 0;
		int topk = ParametersCollection["Parameters"]["parameter_topk"];
		int recotype = (int)ParametersCollection["Parameters"]["parameter_recotype"];
		SupportFunctions.Recommend(sprs[0], sprs[1], sprs[2], InputContainer[0].DataSource, null, ccolR, ccolC, ccolV, OutputContainer, topk, recotype, ifault);
		if(ifault == 1)
			{
				return;
			}
	}
}

public class SupportFunctions
{
	[System.Runtime.InteropServices.DllImport("sta_func.dll", CallingConvention = System.Runtime.InteropServices.CallingConvention.StdCall)]
	public static extern int rawDataSoftImpSVD(ref object input, ref object A, ref object B, ref object D, ref object result1, ref object result2, ref object result3, ref object result4, ref object result5, int r, int nc, int maxitr, double lambda,  double tol, int cr, int g, double s, int ng, int warm, int bisec, int rsorted, int nss, int sparse, int svec, int ccolR, int ccolC, int ccolV, int comp, int m,  int n, int effr, int predfull);
	[System.Runtime.InteropServices.DllImport("sta_func.dll", CallingConvention = System.Runtime.InteropServices.CallingConvention.StdCall)]
	public static extern int StringFromCode(ref int ifault, ref object errmsg);

	public static string Serialize(string[] values)
	{
		return StatSoft.DataMinerNodes.ViewModel.Serialization.SerializeObject<string[]>(values);
	}
	
	public static dynamic GetPropertyCollections(dynamic Host)
	{
		var ParametersCollection = new Dictionary<string, Dictionary<string, object>>();
		var gcnData = Host.ParametersObject.NodeData;
		int i = 0;
		if (gcnData != null)
		{
			foreach(var tabObj in gcnData.Tabs)
			{
				if (tabObj != null && tabObj is ParametersPageData)
				{
					i++;
					string sKey = tabObj.TabName;
					ParametersCollection[sKey] = tabObj.Parameters.FieldValues;
				}
			}
		}
		return ParametersCollection;
	}
	
	public static DataMinerModelBase.NodeIdentifier ALSDeploymentNodeIdentifier = new DataMinerModelBase.NodeIdentifier { dmiFile = "\\NewNodes\\ALSDeployment.DMI", clsid = "{c9e2a530-3d45-11d4-9ff4-00c04fa0d540}" };

	public static bool AddModelNode(STATISTICADataMiner.DataMinerNode pThisNode, STATISTICA.Spreadsheet[] models)
	{
		STATISTICADataMiner.IDMNodeHelper oDM = pThisNode.Parent as STATISTICADataMiner.IDMNodeHelper;
		StatSoft.DataMinerNodes.ViewModel.DeploymentModelBase omodel = new StatSoft.DataMinerNodes.ViewModel.DeploymentModelBase();
		List<string> sims = new List<string>();
		for(int i=0; i<models.Length;i++)
		{
			if(models[i] != null)
				sims.Add(models[i].get_ContentData(STATISTICA.FileFormat.scSTACompressedBase64) as string);
		}
		var icode = 144;
		object nodename = "";
		SupportFunctions.StringFromCode(ref icode, ref nodename); 
		omodel.Model = SupportFunctions.Serialize(sims.ToArray()); //model.get_ContentData(STATISTICA.FileFormat.scSTACompressedBase64) as string;
		var icode2 = 150;
		object methodname = "";
		SupportFunctions.StringFromCode(ref icode2, ref methodname);
		omodel.Type = (string)(methodname);
		omodel.SVBDeploymentCodeOrFile = "\\Deployment Scripts\\ComputeFromALSModel.svb";
		object xmlModel = omodel.XML();
		DataMinerModelBase.CreatePMMLNode(oDM, pThisNode, ref xmlModel, ALSDeploymentNodeIdentifier, true, DataMinerModelBase.ModelNodeIdentifier);
		STATISTICADataMiner.DataMinerNodes dmModelNodes = pThisNode.get_ChildNodes(STATISTICADataMiner.DMNodeType.scDMAnalysisNode2); 
		if(dmModelNodes != null && dmModelNodes.Count > 0) 
		{ 
			dmModelNodes[1].Name = (string)nodename;
		}
		return true;
	}

	public static object Graph(STATISTICADataMiner.DataMinerNode pThisNode, object input)
	{
		var newanalysis = pThisNode.Application.Analysis (STATISTICA.AnalysisIdentifier.sc2dCaseLinePlots, input);
		STATISTICA.LineCaseProfiles oGD1 = newanalysis.Dialog as STATISTICA.LineCaseProfiles;
		oGD1.set_Variables("*");
		oGD1.GraphType = STATISTICA.TypeOfCaseProfilePlot.scCaseRegularPlot;
		oGD1.FitType = STATISTICA.TypeOfFit.scFitOff;
		var options = oGD1.Options;
		options.DisplayDefaultTitle = false;
		options.TitlePosition = STATISTICA.PositionOfTitle.scTitleTop;
		var icode = 152;
		object plotname = "";
		SupportFunctions.StringFromCode(ref icode, ref plotname);
		options.Title = (string)(plotname);
		var oStaDocs = oGD1.Graphs;
		var oG = ((STATISTICA.StaDocuments)oStaDocs)[1];
		var oGL = ((STATISTICAGraphics.Graph)oG).Content;
		var oAxis_2_2 = ((STATISTICAGraphics.Layout2D)oGL).Axes.get_Axis(STATISTICAGraphics.Axis2DScale.scgAx2DScaleY, STATISTICAGraphics.Axis2DPosition.scgAxPosPrimary);
		oAxis_2_2.Title.Display = false;
		return oG;
	}
	
	public static STATISTICA.Spreadsheet[] GetModel(STATISTICADataMiner.DataMinerNode pThisNode)
	{
		STATISTICADataMiner.IDMNodeHelper dataminer = pThisNode.Parent as STATISTICADataMiner.IDMNodeHelper;
		STATISTICADataMiner.IDMNode idmnode = pThisNode.IDMNode as STATISTICADataMiner.IDMNode;
		if(idmnode == null || !(idmnode is GenericCodeNode.IGCNModelDeployment))
		{
			var icode = 149;
			object modelerr = "";
			SupportFunctions.StringFromCode(ref icode, ref modelerr);
			throw new Exception((string)(modelerr));
		}
		object[] models = (idmnode as GenericCodeNode.IGCNModelDeployment).ModelsConnected(dataminer, pThisNode);
		if(models == null || models.Length <=0)
		{
			var icode = 146;
			object modelerr = "";
			SupportFunctions.StringFromCode(ref icode, ref modelerr);
			throw new Exception((string)(modelerr));
		}
		if(models.Length > 1)
		{
			var icode = 147;
			object modelerr = "";
			SupportFunctions.StringFromCode(ref icode, ref modelerr);
			throw new Exception((string)(modelerr));
		}
		StatSoft.DataMinerNodes.ViewModel.Nodes.IPMMLContainer model = models[0] as StatSoft.DataMinerNodes.ViewModel.Nodes.IPMMLContainer;
		StatSoft.DataMinerNodes.ViewModel.DeploymentModelBase omodel = StatSoft.DataMinerNodes.ViewModel.DeploymentModelBase.CreateObject(model.PMML);
		if(omodel == null)
		{
			var icode = 148;
			object modelerr = "";
			SupportFunctions.StringFromCode(ref icode, ref modelerr);
			throw new Exception((string)(modelerr));
		}
		string[] sim = Deserialize(omodel.Model);		
		List<STATISTICA.Spreadsheet> sprs = new List<STATISTICA.Spreadsheet>();
		for(int i = 0 ; i < sim.Length; i++)
		{
			if(sim[i] == null)
				continue;
			STATISTICA.Spreadsheet spr = pThisNode.Application.Spreadsheets.New() as STATISTICA.Spreadsheet;	
			spr.ImportData(STATISTICA.FileFormat.scSTACompressedBase64, sim[i]);
			sprs.Add(spr);
		}
		return sprs.ToArray();
	}

	public static string[] Deserialize(string xml)
	{
		return StatSoft.DataMinerNodes.ViewModel.Serialization.DeserializeObject<string[]>(xml) as string[];
	}

	[DllImport("sta_func.dll", CallingConvention = CallingConvention.StdCall)]
	public static extern int recommender1(ref object A, ref object B, ref object D, ref object rowids, ref object input, int ccolR, int ccolC, int ccolV, ref object outpred, ref object outreco, int topk, int recotype);
	
	public static void Recommend(object A, object B, object D, object rowids, object inputData, int ccolR, int ccolC, int ccolV, STATISTICA.StaDocCollection OutputContainer, int topk, int recotype, int ifault)
	{		
		object outpred = null;
		object outreco = null;	
		ifault = recommender1(ref A, ref B, ref D, ref rowids, ref inputData, ccolR, ccolC, ccolV, ref outpred, ref outreco, topk, recotype);
		if(ifault == 1)
			{
				return;
			}
		(outpred as Spreadsheet).AutoFitVariables();
		(outpred as Spreadsheet).AutoFitCase();
		OutputContainer.Add(outpred);
		(outreco as Spreadsheet).AutoFitVariables();
		(outreco as Spreadsheet).AutoFitCase();
		OutputContainer.Add(outreco);
	}	
	
}
